<?php

namespace RtRasel\LaravelInstaller\Controllers;


use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Constants\Installer;
use RtRasel\LaravelInstaller\Helpers\RequirementsChecker;

class RequirementsController extends Controller
{
    /**
     * @var RequirementsChecker
     */
    protected $requirements;

    /**
     * @param  RequirementsChecker  $checker
     */
    public function __construct(RequirementsChecker $checker)
    {
        $this->requirements = $checker;
    }

    /**
     * Display the requirements page.
     *
     * @return \Illuminate\View\View
     */
    public function requirements()
    {
        $phpSupportInfo = $this->requirements->checkPHPversion(
            Installer::CONFIG['core']['minPhpVersion']
        );
        $ioncubeSupportInfo = $this->requirements->checkIoncubeversion(
            Installer::CONFIG['core']['minIoncubeVersion']
        );
        $requirements = $this->requirements->check(
            Installer::CONFIG['requirements']
        );

        if (!isset($requirements['errors']) && $phpSupportInfo['supported']) {
            session()->put('requirements', true);
        }
        
        return view('laravelinstaller::requirements', compact('requirements', 'phpSupportInfo', 'ioncubeSupportInfo'));
    }
}
